package com.agilex.healthcare.veteranappointment.datalayer.appointment;

import com.agilex.healthcare.veteranappointment.datalayer.PersistenceObject;
import com.agilex.healthcare.veteranappointment.datalayer.Transformable;
import com.agilex.healthcare.veteranappointment.datalayer.patient.PatientPo;
import com.agilex.healthcare.veteranappointment.domain.CCAppointmentRequest;
import com.agilex.healthcare.veteranappointment.domain.Provider;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import org.hibernate.annotations.GenericGenerator;

import java.util.Set;
import java.util.HashSet;
import java.util.List;

import javax.persistence.*;

@Entity
@Table(name = CCAppointmentRequestPo.TABLE_NAME)
@XStreamAlias("CCAppointmentRequest")
public class CCAppointmentRequestPo extends PersistenceObject implements Transformable<CCAppointmentRequest> {
    private static final long serialVersionUID = 1285362900973753379L;
    public static final String TABLE_NAME = "CC_APPOINTMENT_REQUEST";


    private AppointmentRequestPo appointmentRequest;
    private Boolean travelBurden;
    private Boolean unusualTravelBurden;
    private String address;
    private String city;
    private String state;
    private String zipCode;
    private String preferredZipCode;
    private String preferredState;
    private String preferredCity;
    private int distanceWillingToTravel;
    private String preferredLanguage;
    @XStreamImplicit(itemFieldName="OfficeHours")
    private Set<String> officeHours = new HashSet<String>();
    private boolean distanceEligible;
    private Set<ProviderPo> preferredProviders = new HashSet<ProviderPo>();

    public CCAppointmentRequestPo() {
    }

    public CCAppointmentRequestPo(CCAppointmentRequest dto) {
        AppointmentRequestPo appointmentRequest = new AppointmentRequestPo();
        appointmentRequest.setActiveFlag(dto.isActiveFlag());
        appointmentRequest.setAppointmentRequestId(dto.getAppointmentRequestId());
        appointmentRequest.setVisitType(dto.getVisitType());
        appointmentRequest.setAppointmentType(dto.getAppointmentType());
        appointmentRequest.setCreatedDate(dto.getCreatedDate());
        appointmentRequest.setDeletedDate(dto.getDeletedDate());
        appointmentRequest.setEmail(dto.getEmail());
        appointmentRequest.setFacility(new FacilityPo(dto.getFacility()));
        appointmentRequest.setOptionDate1(dto.getOptionDate1());
        appointmentRequest.setOptionTime1(dto.getOptionTime1());
        appointmentRequest.setOptionDate2(dto.getOptionDate2());
        appointmentRequest.setOptionTime2(dto.getOptionTime2());
        appointmentRequest.setOptionDate3(dto.getOptionDate3());
        appointmentRequest.setOptionTime3(dto.getOptionTime3());
        appointmentRequest.setPhoneNumber(dto.getPhoneNumber());
        appointmentRequest.setLastUpdatedDate(dto.getLastUpdatedDate());
        appointmentRequest.setStatus(dto.getStatus());
        appointmentRequest.setId(dto.getUniqueId());
        appointmentRequest.setBestTimetoCall(dto.getBestTimetoCall());
        appointmentRequest.setPurposeOfVisit(dto.getPurposeOfVisit());
        appointmentRequest.setOtherPurposeOfVisit(dto.getOtherPurposeOfVisit());
        appointmentRequest.setProviderId(dto.getProviderId());
        appointmentRequest.setProviderName(dto.getProviderName());
        appointmentRequest.setProviderPersonClass(dto.getProviderPersonClass());
        appointmentRequest.setProviderOption(dto.getProviderOption());
        appointmentRequest.setSecondRequest(dto.isSecondRequest());
        appointmentRequest.setAppointmentDate(dto.getAppointmentDate());
        appointmentRequest.setAppointmentTime(dto.getAppointmentTime());
        appointmentRequest.setAppointmentRequestDetailCode(appointmentRequest.toPo(dto.getAppointmentRequestDetailCode()));

        appointmentRequest.setPatient(new PatientPo(dto.getPatient()));
        appointmentRequest.setTextMessagingAllowed(dto.isTextMessagingAllowed());
        appointmentRequest.setTextMessagingPhoneNumber(dto.getTextMessagingPhoneNumber());

        appointmentRequest.setSecondRequestSubmitted(dto.isSecondRequestSubmitted());

        appointmentRequest.setHasProviderNewMessage(dto.isHasProviderNewMessage());
        appointmentRequest.setHasVeteranNewMessage(dto.isHasVeteranNewMessage());
        appointmentRequest.setProviderSeenAppointmentRequest(dto.isProviderSeenAppointmentRequest());
        appointmentRequest.setRequestedPhoneCall(dto.isRequestedPhoneCall());
        appointmentRequest.setBookedApptDateTime(dto.getBookedApptDateTime());
        appointmentRequest.setTypeOfCareId(dto.getTypeOfCareId());
        appointmentRequest.setReasonForVisit(dto.getReasonForVisit());
        appointmentRequest.setOtherReasonForVisit(dto.getOtherReasonForVisit());
        appointmentRequest.setAdditionalInformation(dto.getAdditionalInformation());
        appointmentRequest.setFriendlyLocationName(dto.getFriendlyLocationName());
        for (AppointmentRequestDetailCodePo arDetailCodePo: appointmentRequest.getAppointmentRequestDetailCode()) {
            arDetailCodePo.setAppointmentRequest(appointmentRequest);
        }

        if (dto.getParentRequest() != null){
            AppointmentRequestPo parentRequestPo = new AppointmentRequestPo(dto.getParentRequest());
            appointmentRequest.setParentRequest(parentRequestPo);
        }

        setAppointmentRequest(appointmentRequest);
        setTravelBurden(dto.getTravelBurden());
        setUnusualTravelBurden(dto.getUnusualTravelBurden());
        setAddress(dto.getAddress());
        setCity(dto.getCity());
        setState(dto.getState());
        setZipCode(dto.getZipCode());
        setPreferredZipcode(dto.getPreferredZipCode());
        setPreferredState(dto.getPreferredState());
        setPreferredCity(dto.getPreferredCity());
        setPreferredLanguage(dto.getPreferredLanguage());
        List<Provider> providers = dto.getPreferredProviders();
        for (int i = 0; i < providers.size(); i++) {
            ProviderPo providerPo = new ProviderPo(providers.get(i), i);
            if(providerPo.isValid()) {
                this.preferredProviders.add(providerPo);
            }
        }

        setDistanceWillingToTravel(dto.getDistanceWillingToTravel());
        setDistanceEligible(dto.getDistanceEligible());
        setOfficeHours(dto.getOfficeHours());
    }

    @Id
    @GeneratedValue(generator="cc_appointment_request_id_generator")
    @GenericGenerator(name="cc_appointment_request_id_generator", strategy = "uuid")
    @Column(name = "CC_APPOINTMENT_REQUEST_ID")
    public String getCcAppointmentRequestId() {
        return super.getId();
    }

    public void setCcAppointmentRequestId(String ccAppointmentRequestId) {
        super.setId(ccAppointmentRequestId);
    }

    @OneToOne(targetEntity = AppointmentRequestPo.class, cascade=CascadeType.ALL, optional = false)
    @JoinColumn(name="APPOINTMENT_REQUEST_ID")
    public AppointmentRequestPo getAppointmentRequest() {
        return appointmentRequest;
    }

    public void setAppointmentRequest(AppointmentRequestPo appointmentRequest) {
        this.appointmentRequest = appointmentRequest;
    }

    @Column(name = "TRAVEL_BURDEN")
    public Boolean getTravelBurden() {
        return travelBurden;
    }

    public void setTravelBurden(Boolean travelBurden) {
        this.travelBurden = travelBurden;
    }

    @Column(name = "UNUSUAL_TRAVEL_BURDEN")
    public Boolean getUnusualTravelBurden() {
        return unusualTravelBurden;
    }

    public void setUnusualTravelBurden(Boolean unusualTravelBurden) {
        this.unusualTravelBurden = unusualTravelBurden;
    }

    @Column(name = "ADDRESS")
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Column(name = "CITY")
    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    @Column(name = "STATE")
    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Column(name = "ZIPCODE")
    public String getZipCode() {
        return zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    @Column(name = "PREFERRED_ZIPCODE")
    public String getPreferredZipcode() {
        return preferredZipCode;
    }

    public void setPreferredZipcode(String preferredZipCode) {
        this.preferredZipCode = preferredZipCode;
    }

    @Column(name = "PREFERRED_CITY")
    public String getPreferredCity() {
        return preferredCity;
    }

    public void setPreferredCity(String preferredCity) {
        this.preferredCity = preferredCity;
    }

    @Column(name = "PREFERRED_STATE")
    public String getPreferredState() {
        return preferredState;
    }

    public void setPreferredState(String preferredState) {
        this.preferredState = preferredState;
    }

    @Column(name="PREFERRED_LANGUAGE")
    public String getPreferredLanguage() {
        return preferredLanguage;
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    @Column(name = "DISTANCE_WILLING_TO_TRAVEL")
    public int getDistanceWillingToTravel() {
        return distanceWillingToTravel;
    }

    public void setDistanceWillingToTravel(int distanceWillingToTravel) {
        this.distanceWillingToTravel = distanceWillingToTravel;
    }

    @Column(name = "DISTANCE_ELIGIBLE")
    public boolean getDistanceEligible() {
        return distanceEligible;
    }
    public void setDistanceEligible(boolean distanceEligible) {
        this.distanceEligible = distanceEligible;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(
            name="OFFICE_HOURS",
            joinColumns=@JoinColumn(name="CC_APPOINTMENT_REQUEST_ID")
    )
    @Column(name="OFFICE_TIME")
    public Set<String> getOfficeHours() {
        return officeHours;
    }

    public void setOfficeHours(Set<String> officeHours) {
        this.officeHours = officeHours;
    }

    @JoinColumn(name="CC_APPOINTMENT_REQUEST_ID")
    @OneToMany(cascade=CascadeType.ALL, fetch=FetchType.EAGER)
    public Set<ProviderPo> getPreferredProviders() {
        return preferredProviders;
    }

    public void setPreferredProviders(Set<ProviderPo> preferredProviders) {
        this.preferredProviders = preferredProviders;
    }

    @Override
    public CCAppointmentRequest create() {
        CCAppointmentRequest dto = new CCAppointmentRequest();

        dto.setActiveFlag(appointmentRequest.isActiveFlag());
        dto.setAppointmentRequestId(appointmentRequest.getAppointmentRequestId());
        dto.setAppointmentType(appointmentRequest.getAppointmentType());
        dto.setVisitType(appointmentRequest.getVisitType());
        dto.setCreatedDate(appointmentRequest.getCreatedDate());
        dto.setDeletedDate(appointmentRequest.getDeletedDate());
        dto.setEmail(appointmentRequest.getEmail());
        dto.setFacility(appointmentRequest.getFacility().create());
        dto.setOptionDate1(appointmentRequest.getOptionDate1());
        dto.setOptionTime1(appointmentRequest.getOptionTime1());
        dto.setOptionDate2(appointmentRequest.getOptionDate2());
        dto.setOptionTime2(appointmentRequest.getOptionTime2());
        dto.setOptionDate3(appointmentRequest.getOptionDate3());
        dto.setOptionTime3(appointmentRequest.getOptionTime3());
        dto.setPhoneNumber(appointmentRequest.getPhoneNumber());
        dto.setLastUpdatedDate(appointmentRequest.getLastUpdatedDate());
        dto.setStatus(appointmentRequest.getStatus());

        //this is set to the appointment request id because the appointment id is what is used for messages
        dto.setUniqueId(appointmentRequest.getId());

        dto.setBestTimetoCall(appointmentRequest.getBestTimetoCall());
        dto.setPurposeOfVisit(appointmentRequest.getPurposeOfVisit());
        dto.setOtherPurposeOfVisit(appointmentRequest.getOtherPurposeOfVisit());
        dto.setProviderId(appointmentRequest.getProviderId());
        dto.setProviderName(appointmentRequest.getProviderName());
        dto.setProviderPersonClass(appointmentRequest.getProviderPersonClass());
        dto.setProviderOption(appointmentRequest.getProviderOption());

        dto.setPatient(appointmentRequest.getPatient().create());
        dto.setPatientId(appointmentRequest.getPatient().getUserId());
        dto.setTextMessagingAllowed(appointmentRequest.isTextMessagingAllowed());
        dto.setTextMessagingPhoneNumber(appointmentRequest.getTextMessagingPhoneNumber());

        dto.setSecondRequest(appointmentRequest.isSecondRequest());

        dto.setAppointmentDate(appointmentRequest.getAppointmentDate());
        dto.setAppointmentTime(appointmentRequest.getAppointmentTime());

        dto.setSecondRequestSubmitted(appointmentRequest.isSecondRequestSubmitted());


        dto.setAppointmentRequestDetailCode(appointmentRequest.appointmentRequestDetailCodeToDto(appointmentRequest.getAppointmentRequestDetailCode()));
        dto.setHasProviderNewMessage(appointmentRequest.isHasProviderNewMessage());
        dto.setHasVeteranNewMessage(appointmentRequest.isHasVeteranNewMessage());
        dto.setProviderSeenAppointmentRequest(appointmentRequest.isProviderSeenAppointmentRequest());
        dto.setSystemId("var");
        dto.setRequestedPhoneCall(appointmentRequest.isRequestedPhoneCall());
        dto.setBookedApptDateTime(appointmentRequest.getBookedApptDateTime());
        dto.setTypeOfCareId(appointmentRequest.getTypeOfCareId());
        dto.setReasonForVisit(appointmentRequest.getReasonForVisit());
        dto.setOtherReasonForVisit(appointmentRequest.getOtherReasonForVisit());
        dto.setAdditionalInformation(appointmentRequest.getAdditionalInformation());
        dto.setFriendlyLocationName(appointmentRequest.getFriendlyLocationName());

        dto.setTravelBurden(travelBurden);
        dto.setUnusualTravelBurden(unusualTravelBurden);
        dto.setAddress(address);
        dto.setCity(city);
        dto.setState(state);
        dto.setZipCode(zipCode);
        dto.setPreferredZipCode(preferredZipCode);
        dto.setPreferredState(preferredState);
        dto.setPreferredCity(preferredCity);
        dto.setPreferredLanguage(preferredLanguage);
        for(ProviderPo providerPo: preferredProviders) {
            dto.getPreferredProviders().add(providerPo.create());
        }
        dto.setDistanceWillingToTravel(distanceWillingToTravel);
        dto.setDistanceEligible(distanceEligible);
        dto.setOfficeHours(officeHours);

        return dto;
    }

    public CCAppointmentRequest createWithoutAppointmentRequest() {
        CCAppointmentRequest dto = new CCAppointmentRequest();

        dto.setTravelBurden(travelBurden);
        dto.setUnusualTravelBurden(unusualTravelBurden);
        dto.setAddress(address);
        dto.setCity(city);
        dto.setState(state);
        dto.setZipCode(zipCode);
        dto.setPreferredZipCode(preferredZipCode);
        dto.setPreferredState(preferredState);
        dto.setPreferredCity(preferredCity);
        dto.setPreferredLanguage(preferredLanguage);
        for(ProviderPo providerPo: preferredProviders) {
            dto.getPreferredProviders().add(providerPo.create());
        }
        dto.setDistanceWillingToTravel(distanceWillingToTravel);
        dto.setDistanceEligible(distanceEligible);
        dto.setOfficeHours(officeHours);

        return dto;
    }

}
